/*
 * Decompiled with CFR 0.152.
 */
package com.stealth.loader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ConfigManager {
    private static final String CONFIG_DIR_NAME = "jackdaniels";
    private static final String USER_ID_FILE = "user_id.txt";
    private static final String DEFAULT_USER_ID = "592cb21e-fd73-4800-b4a9-485303e08434";
    private String userId = this.loadUserId();
    private String configDir = this.getConfigDirectory();

    public ConfigManager() {
        this.setupConfigDirectory();
    }

    private String loadUserId() {
        String string = System.getenv("MIRAISYSTEM_USER_ID");
        if (string != null && !string.trim().isEmpty()) {
            System.out.println("[+] User ID loaded from environment variable");
            return string.trim();
        }
        try {
            int n;
            int n2;
            String string2;
            Path path;
            String string3 = this.getJarDirectory();
            if (string3 != null && Files.exists(path = Paths.get(string3, "user_config.json"), new LinkOption[0]) && (string2 = new String(Files.readAllBytes(path))).contains("\"user_id\"") && (n2 = string2.indexOf("\"", n = string2.indexOf("\"user_id\"") + 10)) > n) {
                String string4 = string2.substring(n, n2);
                System.out.println("[+] User ID loaded from build config file");
                return string4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("[+] User ID loaded from default configuration");
        return DEFAULT_USER_ID;
    }

    private String getJarDirectory() {
        try {
            String string = this.getClass().getSimpleName() + ".class";
            String string2 = this.getClass().getResource(string).toString();
            if (string2.startsWith("jar:")) {
                String string3 = string2.substring(4, string2.lastIndexOf("!"));
                if ((string3 = string3.substring(0, string3.lastIndexOf("/"))).startsWith("file:")) {
                    string3 = string3.substring(5);
                }
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    string3 = string3.replace("/", "\\");
                }
                return string3;
            }
            String string4 = string2.substring(5, string2.lastIndexOf(string));
            if (string4.endsWith("/")) {
                string4 = string4.substring(0, string4.length() - 1);
            }
            return string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getConfigDirectory() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("user.home");
        if (string.contains("windows")) {
            return Paths.get(string2, "AppData", "Roaming", CONFIG_DIR_NAME).toString();
        }
        return Paths.get(string2, ".config", CONFIG_DIR_NAME).toString();
    }

    private void setupConfigDirectory() {
        try {
            Path path = Paths.get(this.configDir, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
                System.out.println("[+] Config directory created: " + this.configDir);
            }
            Path path2 = path.resolve(USER_ID_FILE);
            Files.write(path2, this.userId.getBytes("UTF-8"), new OpenOption[0]);
            System.out.println("[+] User ID saved to: " + path2.toString());
        }
        catch (IOException iOException) {
            System.err.println("[!] Error setting up config directory: " + iOException.getMessage());
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getConfigDir() {
        return this.configDir;
    }
}

